/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.log;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import net.ftb.log.ILogListener;
import net.ftb.log.LogEntry;
import net.ftb.log.LogSource;
import net.ftb.log.LogType;

public class LogWriter
implements ILogListener {
    private final BufferedWriter logWriter;
    private final LogSource source;

    public LogWriter(File logFile, LogSource source) throws IOException {
        this.source = source;
        this.logWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(logFile), "UTF-8"));
        this.logWriter.write(logFile + ": written by FTB Launcher" + System.getProperty("line.separator"));
        this.logWriter.flush();
    }

    @Override
    public void onLogEvent(LogEntry entry) {
        if (entry.source == this.source) {
            try {
                this.logWriter.write(entry.toString(LogType.EXTENDED) + System.getProperty("line.separator"));
                this.logWriter.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

